/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockWorkDialog;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWPropertyChangeNotifier;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Vector;

public final class VWLockWork
implements IVWPropertyChangeSource {
    private Vector m_participants = null;
    private Container m_parent = null;
    private boolean m_success = true;
    private VWTrkDataModel m_dataModel = null;

    public VWLockWork(Frame parent, VWTrkDataModel dataModel) throws Exception {
        this.m_parent = parent;
        this.initializeData(dataModel);
    }

    public VWLockWork(Frame parent, VWTrkDataModel dataModel, Vector steps) throws Exception {
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initializeData(steps);
    }

    public VWLockWork(Frame parent, VWTrkDataModel dataModel, Object[] array) throws Exception {
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initializeData(array);
    }

    public VWLockWork(Frame parent, VWTrkStepOccurrence occurrence) throws Exception {
        this.m_parent = parent;
        this.initializeData(occurrence);
    }

    public VWLockWork(Frame parent, VWTrkParticipant participant) throws Exception {
        this.m_parent = parent;
        this.initializeData(participant);
    }

    public VWLockWork(Dialog parent, VWTrkDataModel dataModel) throws Exception {
        this.m_parent = parent;
        this.initializeData(dataModel);
    }

    public VWLockWork(Dialog parent, VWTrkDataModel dataModel, Vector steps) throws Exception {
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initializeData(steps);
    }

    public VWLockWork(Dialog parent, VWTrkDataModel dataModel, Object[] array) throws Exception {
        this.m_parent = parent;
        this.m_dataModel = dataModel;
        this.initializeData(array);
    }

    public VWLockWork(Dialog parent, VWTrkStepOccurrence occurrence) throws Exception {
        this.m_parent = parent;
        this.initializeData(occurrence);
    }

    public VWLockWork(Dialog parent, VWTrkParticipant participant) throws Exception {
        this.m_parent = parent;
        this.initializeData(participant);
    }

    private void initializeData(Object data) throws Exception {
        if (data == null) {
            this.m_participants = null;
            return;
        }
        this.m_participants = new Vector();
        if (data instanceof VWTrkDataModel) {
            data = ((VWTrkDataModel)data).getStepCollection();
        }
        if (data instanceof Vector) {
            this.initData((Vector)data);
        } else if (data.getClass().isArray()) {
            this.initData((Object[])data);
        } else if (data instanceof VWTrkStep) {
            this.initData((VWTrkStep)data);
        } else if (data instanceof VWTrkStepOccurrence) {
            this.initData((VWTrkStepOccurrence)data);
        } else if (data instanceof VWTrkParticipant) {
            this.initData((VWTrkParticipant)data);
        }
        if (this.m_participants.size() == 0) {
            this.m_participants = null;
            return;
        }
        this.notifyPropertyChange();
        if (!this.m_success) {
            try {
                VWLockWorkDialog dlg = null;
                dlg = this.m_parent instanceof Frame ? new VWLockWorkDialog((Frame)this.m_parent, this) : new VWLockWorkDialog((Dialog)this.m_parent, this);
                dlg.setVisible(true);
                dlg.removeReferences();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private void initData(Vector vector) throws Exception {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object obj = vector.elementAt(i);
            if (obj == null) continue;
            if (obj instanceof VWTrkStep) {
                this.initData((VWTrkStep)obj);
                continue;
            }
            if (obj instanceof VWTrkStepOccurrence) {
                this.initData((VWTrkStepOccurrence)obj);
                continue;
            }
            if (obj instanceof VWTrkParticipant) {
                this.initData((VWTrkParticipant)obj);
                continue;
            }
            if (!(obj instanceof VWStepDefinition)) continue;
            if (this.m_dataModel != null) {
                this.initData(this.m_dataModel.findStep(((VWStepDefinition)obj).getStepId()));
                continue;
            }
            throw new Exception(VWResource.s_needDataModel.toString(VWResource.s_lockWork));
        }
    }

    private void initData(Object[] array) throws Exception {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            Object obj = array[i];
            if (obj == null) continue;
            if (obj instanceof VWTrkStep) {
                this.initData((VWTrkStep)obj);
                continue;
            }
            if (obj instanceof VWTrkStepOccurrence) {
                this.initData((VWTrkStepOccurrence)obj);
                continue;
            }
            if (obj instanceof VWTrkParticipant) {
                this.initData((VWTrkParticipant)obj);
                continue;
            }
            if (!(obj instanceof VWStepDefinition)) continue;
            if (this.m_dataModel != null) {
                this.initData(this.m_dataModel.findStep(((VWStepDefinition)obj).getStepId()));
                continue;
            }
            throw new Exception(VWResource.s_needDataModel.toString(VWResource.s_lockWork));
        }
    }

    private void initData(VWTrkStep step) {
        if (step == null) {
            return;
        }
        Vector activeOccurrences = step.getActiveOccurrences();
        if (activeOccurrences != null) {
            for (int i = 0; i < activeOccurrences.size(); ++i) {
                Object obj = activeOccurrences.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkStepOccurrence)) continue;
                this.lockOccurrence((VWTrkStepOccurrence)obj);
            }
        }
    }

    private void initData(VWTrkStepOccurrence occurrence) {
        if (occurrence == null) {
            return;
        }
        this.lockOccurrence(occurrence);
    }

    private void initData(VWTrkParticipant participant) {
        if (participant == null) {
            return;
        }
        this.lockParticipant(participant);
    }

    private void lockOccurrence(VWTrkStepOccurrence occurrence) {
        if (occurrence == null) {
            return;
        }
        if (occurrence.isActive() && !occurrence.isLockedByCurrentUserEntirely()) {
            Vector participants = occurrence.getParticipantCollection();
            for (int j = 0; j < participants.size(); ++j) {
                Object obj = participants.elementAt(j);
                if (obj == null || !(obj instanceof VWTrkParticipant)) continue;
                VWTrkParticipant participant = (VWTrkParticipant)participants.elementAt(j);
                this.lockParticipant(participant);
            }
        }
    }

    private void lockParticipant(VWTrkParticipant participant) {
        if (participant == null) {
            return;
        }
        if (participant.isActive() && !participant.isLockedByCurrentUser()) {
            this.m_participants.addElement(participant);
            this.m_success &= participant.lockWork();
        }
    }

    public boolean isSuccess() {
        return this.m_success;
    }

    public boolean isAnyParticipant() {
        return this.m_participants != null && this.m_participants.size() > 0;
    }

    public Vector getParticipants() {
        return this.m_participants;
    }

    public void unlock() {
        if (this.m_participants == null) {
            return;
        }
        for (int i = 0; i < this.m_participants.size(); ++i) {
            VWTrkParticipant participant = (VWTrkParticipant)this.m_participants.elementAt(i);
            participant.unlockWork(false, false);
        }
        this.notifyPropertyChange();
    }

    public void notifyPropertyChange() {
        if (this.m_participants != null && this.m_participants.size() > 0) {
            VWPropertyChangeNotifier.notifyPropertyChange(new VWPropertyChangeEvent(this, 701));
        }
    }

    public Vector getItemsChanged() {
        Vector<VWTrkStep> steps = new Vector<VWTrkStep>();
        if (this.m_participants != null) {
            for (int i = 0; i < this.m_participants.size(); ++i) {
                VWTrkParticipant participant = (VWTrkParticipant)this.m_participants.elementAt(i);
                VWTrkStep step = participant.getStep();
                for (int j = 0; j < steps.size(); ++j) {
                    if (step != steps.elementAt(j)) continue;
                    step = null;
                    break;
                }
                if (step == null) continue;
                steps.addElement(step);
            }
        }
        return steps;
    }

    public void removeReferences() {
        if (this.m_participants != null) {
            this.m_participants.removeAllElements();
            this.m_participants = null;
        }
        this.m_parent = null;
        this.m_dataModel = null;
    }
}

